import { createSlice } from "@reduxjs/toolkit";
import * as SecureStore from "expo-secure-store";
import { DEFAULT_LANG } from "../../../src/constants/languageConst";

const initialState = {
    lng: DEFAULT_LANG,
};

const language = createSlice({
    name: "language",
    initialState,
    reducers: {
        setLanguage: (state, { payload }) => {
            state.lng = payload;
            SecureStore.setItemAsync('languageCode', payload);
        },
    },
});

export const { setLanguage } = language.actions;
export default language.reducer;
